/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal.custom_portal_gen;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleBlockPredicate
implements Predicate<class_2680> {
    public static final SimpleBlockPredicate pass = new SimpleBlockPredicate();
    public final String name;
    @Nullable
    private final class_6862<class_2248> tag;
    @Nullable
    private final class_6880<class_2248> blockHolder;
    public static final Codec<SimpleBlockPredicate> CODEC = new SimpleBlockPredicateCodec();

    public SimpleBlockPredicate(String name, @NotNull class_6862<class_2248> tag) {
        this.name = name;
        this.tag = tag;
        this.blockHolder = null;
    }

    public SimpleBlockPredicate(String name, @NotNull class_6880<class_2248> blockHolder) {
        this.name = name;
        this.blockHolder = blockHolder;
        this.tag = null;
    }

    private SimpleBlockPredicate() {
        this.tag = null;
        this.blockHolder = null;
        this.name = "imm_ptl:pass";
    }

    @Override
    public boolean test(class_2680 blockState) {
        if (this.tag != null) {
            return blockState.method_26164(this.tag);
        }
        if (this.blockHolder != null) {
            return blockState.method_26204() == this.blockHolder.comp_349();
        }
        return true;
    }

    private static class SimpleBlockPredicateCodec
    implements Codec<SimpleBlockPredicate> {
        private SimpleBlockPredicateCodec() {
        }

        public <T> DataResult<Pair<SimpleBlockPredicate, T>> decode(DynamicOps<T> ops, T input) {
            if (!(ops instanceof class_6903)) {
                return DataResult.error(() -> "To deserialize SimpleBlockPredicate, the DynamicOps must be RegistryOps");
            }
            class_6903 registryOps = (class_6903)ops;
            DataResult stringValue = ops.getStringValue(input);
            if (stringValue.result().isEmpty()) {
                return DataResult.error(() -> "SimpleBlockPredicate should be string");
            }
            String str = (String)stringValue.result().get();
            Optional optionalGetter = registryOps.method_46634(class_7924.field_41254);
            if (optionalGetter.isEmpty()) {
                return DataResult.error(() -> "Missing block registry");
            }
            class_7871 getter = (class_7871)optionalGetter.get();
            if (str.startsWith("#")) {
                String blockTagIdStr = str.substring(1);
                DataResult bockTagRl = class_2960.method_29186((String)blockTagIdStr);
                if (bockTagRl.result().isEmpty()) {
                    return DataResult.error(() -> "Invalid block tag id:" + blockTagIdStr);
                }
                class_2960 resourceLocation = (class_2960)bockTagRl.result().get();
                class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)resourceLocation);
                return DataResult.success((Object)Pair.of((Object)new SimpleBlockPredicate(str, (class_6862<class_2248>)tagKey), (Object)ops.empty()), (Lifecycle)Lifecycle.stable());
            }
            DataResult rl = class_2960.method_29186((String)str);
            if (rl.result().isEmpty()) {
                return DataResult.error(() -> "Invalid resource location:" + str);
            }
            class_2960 resourceLocation = (class_2960)rl.result().get();
            if (resourceLocation.toString().equals("minecraft:air")) {
                return DataResult.success((Object)Pair.of((Object)new AirPredicate(), (Object)ops.empty()), (Lifecycle)Lifecycle.stable());
            }
            Optional blockRef = getter.method_46746(class_5321.method_29179((class_5321)class_7924.field_41254, (class_2960)resourceLocation));
            if (blockRef.isEmpty()) {
                class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)resourceLocation);
                return DataResult.success((Object)Pair.of((Object)new SimpleBlockPredicate(str, (class_6862<class_2248>)tagKey), (Object)ops.empty()), (Lifecycle)Lifecycle.stable());
            }
            return DataResult.success((Object)Pair.of((Object)new SimpleBlockPredicate(str, (class_6880<class_2248>)((class_6880)blockRef.get())), (Object)ops.empty()), (Lifecycle)Lifecycle.stable());
        }

        public <T> DataResult<T> encode(SimpleBlockPredicate input, DynamicOps<T> ops, T prefix) {
            return DataResult.success((Object)ops.createString(input.name), (Lifecycle)Lifecycle.stable());
        }
    }

    public static class AirPredicate
    extends SimpleBlockPredicate {
        public AirPredicate() {
            super("minecraft:air", (class_6880<class_2248>)class_2246.field_10124.method_40142());
        }

        @Override
        public boolean test(class_2680 blockState) {
            return blockState.method_26215();
        }
    }
}

